/*
  4xGLSLHqFilter Smart shader 

           - Copyright (C) 2009 guest(r) - guest.r@gmail.com

           - License: GNU-GPL  

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifdef SHADER_MODEL // make safe to include in resource file to enforce dependency

#define OFFSET 0.001 // Messed with it until it looked fine (like Shader Level)

Texture2D Texture;
SamplerState TextureSampler;

struct PS_INPUT
{
	float4 p : SV_Position;
	float2 t : TEXCOORD0;
};

struct PS_OUTPUT
{
	float4 c : SV_Target0;
};

static const float3 dt = {1.0,1.0,1.0};

static const float mx = 1.00;     // start smoothing wt.
static const float k = -1.10;     // wt. decrease factor
static const float max_w = 0.75;  // max filter weigth
static const float min_w = 0.02;   // min filter weigth
static const float lum_add = 0.33; // effects smoothing


float3 GLSL4x_HqFilter(float3 c,float3 o1,float3 o2,float3 o3, float3 o4, float3 i1,float3 i2,float3 i3, float3 i4, float3 s1, float3 s2, float3 s3, float3 s4)
{
	float ko1=dot(abs(o1-c),dt);
	float ko2=dot(abs(o2-c),dt);
	float ko3=dot(abs(o3-c),dt);
	float ko4=dot(abs(o4-c),dt);

	float k1=min(dot(abs(i1-i3),dt),max(ko1,ko3));
	float k2=min(dot(abs(i2-i4),dt),max(ko2,ko4));

	float w1 = k2; if(ko3<ko1) w1*=ko3/ko1;
	float w2 = k1; if(ko4<ko2) w2*=ko4/ko2;
	float w3 = k2; if(ko1<ko3) w3*=ko1/ko3;
	float w4 = k1; if(ko2<ko4) w4*=ko2/ko4;

	c=(w1*o1+w2*o2+w3*o3+w4*o4+0.001*c)/(w1+w2+w3+w4+0.001);

	w1 = k*dot(abs(i1-c)+abs(i3-c),dt)/(0.125*dot(i1+i3,dt)+lum_add);
	w2 = k*dot(abs(i2-c)+abs(i4-c),dt)/(0.125*dot(i2+i4,dt)+lum_add);
	w3 = k*dot(abs(s1-c)+abs(s3-c),dt)/(0.125*dot(s1+s3,dt)+lum_add);
	w4 = k*dot(abs(s2-c)+abs(s4-c),dt)/(0.125*dot(s2+s4,dt)+lum_add);

	w1 = clamp(w1+mx,min_w,max_w); 
	w2 = clamp(w2+mx,min_w,max_w);
	w3 = clamp(w3+mx,min_w,max_w); 
	w4 = clamp(w4+mx,min_w,max_w);

	return (w1*(i1+i3)+w2*(i2+i4)+w3*(s1+s3)+w4*(s2+s4)+c)/(2.0*(w1+w2+w3+w4)+1.0);
}



PS_OUTPUT ps_main(PS_INPUT input)
{

	PS_OUTPUT output;
	float2 pos2 = input.t;
	
	// Calculating texel coordinates
	float2 size     = float2(4096.0,2048.0);
	float2 inv_size = float2(1.0/4096.0, 1.0/2048.0);
	
	float2 OGL2Pos = pos2.xy*size;
	float2 dx  = float2(inv_size.x,0.0);
	float2 dy  = float2(0.0,inv_size.y);

	float2 start_crd = floor(OGL2Pos)*inv_size;

	float2 pos = frac(OGL2Pos);
	float2 offset2 = floor(pos);
	float2 fp  = frac(pos);   

	// Reading the texels

	float3 c00 = Texture.Sample(TextureSampler,start_crd + offset2                  ).xyz;
	float3 c10 = Texture.Sample(TextureSampler,start_crd + offset2 +     dx         ).xyz;
	float3 c40 = Texture.Sample(TextureSampler,start_crd + offset2 + 4.0*dx         ).xyz;
	float3 c50 = Texture.Sample(TextureSampler,start_crd + offset2 + 5.0*dx         ).xyz;

	float3 c01 = Texture.Sample(TextureSampler,start_crd + offset2 +              dy).xyz;
	float3 c11 = Texture.Sample(TextureSampler,start_crd + offset2 +     dx +     dy).xyz;
	float3 c21 = Texture.Sample(TextureSampler,start_crd + offset2 + 2.0*dx +     dy).xyz;
	float3 c31 = Texture.Sample(TextureSampler,start_crd + offset2 + 3.0*dx +     dy).xyz;
	float3 c41 = Texture.Sample(TextureSampler,start_crd + offset2 + 4.0*dx +     dy).xyz;
	float3 c51 = Texture.Sample(TextureSampler,start_crd + offset2 + 5.0*dx +     dy).xyz;

	float3 c12 = Texture.Sample(TextureSampler,start_crd + offset2 +     dx + 2.0*dy).xyz;
	float3 c22 = Texture.Sample(TextureSampler,start_crd + offset2 + 2.0*dx + 2.0*dy).xyz;
	float3 c32 = Texture.Sample(TextureSampler,start_crd + offset2 + 3.0*dx + 2.0*dy).xyz;
	float3 c42 = Texture.Sample(TextureSampler,start_crd + offset2 + 4.0*dx + 2.0*dy).xyz;

	float3 c13 = Texture.Sample(TextureSampler,start_crd + offset2 +     dx + 3.0*dy).xyz;
	float3 c23 = Texture.Sample(TextureSampler,start_crd + offset2 + 2.0*dx + 3.0*dy).xyz;
	float3 c33 = Texture.Sample(TextureSampler,start_crd + offset2 + 3.0*dx + 3.0*dy).xyz;
	float3 c43 = Texture.Sample(TextureSampler,start_crd + offset2 + 4.0*dx + 3.0*dy).xyz;

	float3 c04 = Texture.Sample(TextureSampler,start_crd + offset2 +          4.0*dy).xyz;
	float3 c14 = Texture.Sample(TextureSampler,start_crd + offset2 +     dx + 4.0*dy).xyz;
	float3 c24 = Texture.Sample(TextureSampler,start_crd + offset2 + 2.0*dx + 4.0*dy).xyz;
	float3 c34 = Texture.Sample(TextureSampler,start_crd + offset2 + 3.0*dx + 4.0*dy).xyz;
	float3 c44 = Texture.Sample(TextureSampler,start_crd + offset2 + 4.0*dx + 4.0*dy).xyz;
	float3 c54 = Texture.Sample(TextureSampler,start_crd + offset2 + 5.0*dx + 4.0*dy).xyz;

	float3 c05 = Texture.Sample(TextureSampler,start_crd + offset2          + 5.0*dy).xyz;
	float3 c15 = Texture.Sample(TextureSampler,start_crd + offset2 +     dx + 5.0*dy).xyz;
	float3 c45 = Texture.Sample(TextureSampler,start_crd + offset2 + 4.0*dx + 5.0*dy).xyz;
	float3 c55 = Texture.Sample(TextureSampler,start_crd + offset2 + 5.0*dx + 5.0*dy).xyz;


	float3 ul = GLSL4x_HqFilter (c22, c00, c40, c44, c04, c11, c31, c33, c13, c21, c32, c33, c12);
	float3 ur = GLSL4x_HqFilter (c32, c10, c50, c54, c14, c21, c41, c43, c23, c31, c42, c43, c22);
	float3 dl = GLSL4x_HqFilter (c23, c01, c41, c45, c05, c12, c32, c34, c14, c22, c33, c34, c13);
	float3 dr = GLSL4x_HqFilter (c33, c11, c51, c55, c15, c22, c42, c44, c24, c32, c43, c44, c23);
  
	
    output.c.a = 1.0;
	output.c.xyz = (dr*fp.x+dl*(1-fp.x))*fp.y+(ur*fp.x+ul*(1-fp.x))*(1-fp.y);
	return output;

}

#endif